function plotcontours( surf, contourcount, dolabel, linestyle )
% plotcontours( surf, contourcount, dolabel )
% 
% Plot contours using plot function rather than contour function. This
% allows contours to be plotted on top of a surface with a different range
% (and therefore not disturbing its' colormap. For example it can be used
% to plot contours of the gradient of a surface on top of the surface. Or
% for plotting streamlines on top of the head gradient map.
% 
% The dolabel parameter is optional, when true contours are labelled,
% default false.
% 
% Created by Yannick Kremer 2010
% University of Strathclyde
% Glasgow
% mail@ykremer.com


if nargin < 2, 
    contourcount = 10;    
end
if nargin < 3,
   dolabel = false;  
end
if nargin < 4,  
   linestyle = '-w'; 
end
    
    

C = contourc( surf, contourcount ) ;

Cs = contourstruct( C );

plotcontourstruct( Cs, linestyle );

if dolabel, clabel( C ); end